/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.util;

import com.mojang.serialization.Codec;
import com.tristankechlo.livingthings.ForgeLivingThings;
import com.tristankechlo.livingthings.config.GeneralConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class LivingThingsBiomeModifier
implements BiomeModifier {
    private Map<ResourceLocation, List<MobSpawnSettings.SpawnerData>> spawnData = null;
    private static final LivingThingsBiomeModifier INSTANCE = new LivingThingsBiomeModifier();
    public static final Codec<LivingThingsBiomeModifier> CODEC = Codec.unit((Object)INSTANCE);

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        Optional biomeID;
        if (this.spawnData == null) {
            this.spawnData = GeneralConfig.getSpawnData();
        }
        if ((biomeID = biome.m_203543_()).isEmpty()) {
            return;
        }
        ResourceLocation biomeName = ((ResourceKey)biomeID.get()).m_135782_();
        if (phase == BiomeModifier.Phase.ADD && this.spawnData.containsKey(biomeName)) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            List<MobSpawnSettings.SpawnerData> spawnerData = this.spawnData.get(biomeName);
            for (MobSpawnSettings.SpawnerData data : spawnerData) {
                spawns.m_48376_(data.f_48404_.m_20674_(), data);
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ForgeLivingThings.BIOME_MODIFIER_CODEC.get();
    }
}

